 ; Ŀ
 ;   Lf - Linetype finder.                                                 
 ;   Copyright 2006 by Rocket Software Ltd.                                
 ;   There are no sports cars named after amphibians.                      
 ; 

 ; Ŀ
 ;   Ecola - get the colour which an entity appears to be.                 
 ; 
 (DEFUN ECOLA (entt / zz cola)
  (setq zz (cdr (assoc 62 entt)))
  (cond ((or (null zz) (= zz 256))
         (setq cola (cdr (assoc 62 (tblsearch "layer" (cdr (assoc 8 entt)))))))
        ((= zz 0)
         (setq cola 7))
        (t (setq cola zz)))
 cola)
 ; Ŀ
 ;   Ecola end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lbox - display a list of strings in a dialog box.          
 ;   Arguments: Styldt, the list of strings to display.                    
 ;              Dclfil, the dcl file name.                                 
 ;              Dclnam, the dialog box name in the dcl file.               
 ;              Prom, the type for the number of things found prompt.      
 ;              Dianam, the dialog box title.                              
 ;   Returns a text string or nil.                                         
 ; 
 (DEFUN LBOX (styldt dclfil dclnam prom dianam / fpath dcl_id num numf filnam
                                                       fnam malist findx ret)
  (setq dcl_id (load_dialog dclfil))
  (new_dialog dclnam dcl_id)      ; must come before data for list box
  (set_tile "diabox" dianam)
 ; Ŀ
 ;   Make the Style list for the list box.                                 
 ; 
  (start_list "the_list")         ; read ltype data list into list box
  (setq num 0)
  (while (setq stylnm (nth num styldt))
         (add_list stylnm)
         (setq malist (cons stylnm malist))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa num) " " prom))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq findx (selok $reason))")
  (action_tile "the_list" "(setq findx (lisok $reason))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id)
 ; Ŀ
 ;   Return a text string or nil.                                          
 ; 
 (if (and findx (/= findx ""))
     (nth (read findx) malist) nil))
 ; Ŀ
 ;   Lbox end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case return the value of     
 ;   the tile and close the dialog box.                                    
 ; 
 (DEFUN LISOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (done_dialog)
      (set_tile "babtext" ""))
 lisval)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Marck - draw a marker X at a point.                                   
 ; 
 (DEFUN MARCK (pa rad colo / ur ul lr ll)
  (grdraw (setq ur (polar pa (/ pi 4) rad))
          (setq ll (polar pa (* 1.25 pi) rad)) colo)
  (grdraw (setq ul (polar pa (* pi 0.75) rad))
          (setq lr (polar pa (* pi 1.75) rad)) colo)
  (grdraw ur ul 7)
  (grdraw ul ll 7)
  (grdraw ll lr 7)
  (grdraw lr ur 7)
 (princ))
 ; Ŀ
 ;   Marck end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Selok - if OK was pressed, see if a file name was          
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ; 
 (DEFUN SELOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (and lisval (/= lisval ""))
      (done_dialog)
      (set_tile "babtext" "You must select a name."))
 lisval)
 ; Ŀ
 ;   Selok end.                                                            
 ; 

 ; Ŀ
 ;   Lf.                                                                   
 ; 
 (DEFUN C:LF (/ rad rew a stylst lstyl ss enam entt num pa)
  (setvar "cmdecho" 0)
  (setq rad (/ (getvar "viewsize") 20))
 ; Ŀ
 ;   Get a list of linetypes defined in the drawing.                       
 ; 
  (setq rew t)
  (while (setq a (cdr (assoc 2 (tblnext "ltype" rew))))
         (setq stylst (cons a stylst))
         (setq rew ()))
 ; Ŀ
 ;   Put the list n alphabetical order.                                    
 ; 
  (setq stylst (acad_strlsort stylst))
 ; Ŀ
 ;   Call the dialog box to get a text style name from those defined       
 ;   in the drawing.                                                       
 ; 
  (setq lstyl (lbox stylst "lf.dcl" "lf" "Linetypes." "Linetype To Find"))
 ; Ŀ
 ;   Get an ss of all entities in that linetype.                           
 ; 
  (setq ss (ssget "x" (list (cons 6 lstyl))))
 ; Ŀ
 ;   Process the ss.                                                       
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq entt (entget enam))
         (redraw enam 3)
         (if (= (cdr (assoc 0 entt)) "POLYLINE")
             (setq pa (cdr (assoc 10 (entget (entnext enam)))))
             (setq pa (cdr (assoc 10 entt))))
         (marck pa rad (ecola entt))
         (setq num (1+ num)))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (prompt (strcat "\nEntities explicitly linetyped " lstyl ": " (Itoa num)))
 (princ))